import static org.junit.jupiter.api.Assertions.*;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.junit.jupiter.api.Test;

class Tests {
	
	static Set<String> leaves = new HashSet<String>();

	void collectLeaves(String in, Set<String> leaves) {
		ANTLRInputStream input = new ANTLRInputStream(in);
		RelationalAlgebraLexer lexer = new RelationalAlgebraLexer(input);
		CommonTokenStream tokens = new CommonTokenStream(lexer);
		RelationalAlgebraParser parser = new RelationalAlgebraParser(tokens);
		ParseTree context = parser.prog(); 
		TerminalListener listener = new TerminalListener();
		ParseTreeWalker.DEFAULT.walk(listener, context);
		for (Iterator<TerminalNode> iterator = listener.terminalsSet.iterator(); iterator.hasNext();) {
			TerminalNode arg = (TerminalNode) iterator.next();
			leaves.add(arg.getText());
		}
	}
	
	@Test
	void test1() {
		collectLeaves("JOIN(A,B).", leaves);
		Set<String> res = Set.of("A", "B");
		assertEquals(res, leaves);
	}
	
	@Test
	void test2() {
		leaves.clear();
		collectLeaves("JOIN(A,ANTI JOIN(ATOV(h(B),JOIN(C,D)),UNION(E,F))).", leaves);
		Set<String> res = Set.of("A", "B", "C", "D", "E", "F");
		assertEquals(res, leaves);
	}
	@Test
	void test3() {
		leaves.clear();
		collectLeaves(".", leaves);
		assertEquals(true, leaves.isEmpty());
	}
	@Test
	void test4() {
		leaves.clear();
		collectLeaves("ATOV(h(A,B,C),G).", leaves);
		Set<String> res = Set.of("A", "B", "C", "G");
		assertEquals(res, leaves);
	}
	
}
